/*jshint unused: vars */

define(["lib/Zoot", "lib/dev", "lib/tasks"],
function (Z, dev, tasks) {
	"use strict";
	
	var kMovementPosition = 0,
		kMovementRotationCW = 1,
		kMovementRotationCCW = 2;

	return {
		about: "Nutcracker Jaw, (c) 2014.",
		description: "$$$/animal/Behavior/NutcrackerJaw/Desc=Flaps a Jaw-tagged handle up and down based on tracking the openness of your mouth and/or the volume of the audio",
		uiName: "$$$/animal/Behavior/NutcrackerJaw/UIName=Nutcracker Jaw",
		defaultArmedForRecordOn: true,

		defineTags: function () {
			return { 
				aTags: [
					{
						id: "Adobe.FlappyChin.Jaw",
						artMatches: ["jaw"],
						uiName: "$$$/animal/Behavior/FlappyChin/UIName/Jaw=Jaw",
						tagType: "handletag"
					}
				]
			};
		},

		defineParams: function () { // free function, called once ever; returns parameter definition (hierarchical) array
			return [
				{
					id: "cameraInput", type: "eventGraph",
				 	uiName: "$$$/animal/Behavior/NutcrackerJaw/Parameter/cameraInput=Camera Input",
				 	inputKeysArray: ["Head/MouthDY"],
					uiToolTip: "$$$/animal/Behavior/NutcrackerJaw/Parameter/cameraInput/tooltip=Face data from the camera (mouth height only); camera must be enabled",
				 	defaultArmedForRecordOn: true
				},
				{
					id: "audioInput", type: "eventGraph",
				 	uiName: "$$$/animal/Behavior/NutcrackerJaw/Parameter/audioInput=Audio Input",
				 	inputKeysArray: ["Viseme/InputEnabled", "Audio/Amplitude"],
					uiToolTip: "$$$/animal/Behavior/NutcrackerJaw/Parameter/audioInput/tooltip=Louder sounds drive more movement; microphone must be enabled",
				 	defaultArmedForRecordOn: true
				},
				{
					id: "targets", type: "handle",
				 	uiName: "$$$/animal/Behavior/NutcrackerJaw/Parameter/targets=Target Handles",
				 	dephault: { match: "//Adobe.FlappyChin.Jaw"}
				},
				{
					id: "jawFactor", type: "slider",
				 	uiName: "$$$/animal/Behavior/NutcrackerJaw/Parameter/CameraFlappiness=Camera Flappiness",
				 	uiUnits: "%", dephault: 100,
					uiToolTip: "$$$/animal/Behavior/NutcrackerJaw/Parameter/CameraFlappiness/tooltip=How much influence mouth openness has on jaw movement",
				},
				{
					id: "audioFactor", type: "slider",
				 	uiName: "$$$/animal/Behavior/NutcrackerJaw/Parameter/AudioFlappiness=Audio Flappiness",
				 	uiUnits: "%", dephault: 100,
					uiToolTip: "$$$/animal/Behavior/NutcrackerJaw/Parameter/AudioFlappiness/tooltip=How much influence audio volume has on jaw movement",
				},
				{
					id:"movement", type:"enum",
					uiName: "$$$/animal/Behavior/NutcrackerJaw/Parameter/Movement=Movement",
					items: [
						{ id: kMovementPosition,	uiName: "$$$/animal/Behavior/NutcrackerJaw/Parameter/Movement/Positin=Position" },
						{ id: kMovementRotationCW,	uiName: "$$$/animal/Behavior/NutcrackerJaw/Parameter/Movement/RotationCW=Rotation Clockwise" },
						{ id: kMovementRotationCCW,	uiName: "$$$/animal/Behavior/NutcrackerJaw/Parameter/Movement/RotationCCW=Rotation Counterclockwise" },
					],
					dephault: kMovementPosition,
					uiToolTip: "$$$/animal/Behavior/NutcrackerJaw/Parameter/Movement/ToolTip=Choose to either rotate the jaw handle, or move it up & down",
				},
			];
		},
		
		onCreateBackStageBehavior: function (self) {
			return { order: 1.0, importance : 0.0 };
		},

		onCreateStageBehavior: function (self, args) {
			self.targets = args.getStaticParam("targets");
		},

		onAnimate: function (self, args) { // method on behavior that is attached to a puppet, only onstage					
			if (self.targets.length < 1) {
				return;
			}

			var flappiness = args.getParam("jawFactor") * 0.01,
				audioFlappiness = args.getParam("audioFactor") * 0.01,
				opennessFactor, ampFactor,
				bActive = false;

			opennessFactor = args.getParamEventValue("cameraInput", "Head/MouthDY");
			
			// strange that we have to check something related to Viseme, but apparently
			//	that's the only way to see if the mic is on (Audio/Amplitude freezes at last
			//	value when it's off)
			if (args.getParamEventValue("audioInput", "Viseme/InputEnabled")) {
				ampFactor = args.getParamEventValue("audioInput", "Audio/Amplitude");
				// console.logToUser("ampFactor = " + ampFactor); // strangely, ampFactor can exceed 1.0
			}
		
			if (ampFactor) {
				args.setEventGraphParamRecordingValid("audioInput");
				bActive = true;
			} else {
				ampFactor = 0;	// normalize undefined
			}
			
			if (opennessFactor !== undefined) {
				if (opennessFactor < 0) {
					opennessFactor = 0;		// clamp it so it only gets more open, not more closed
				}
				
				args.setEventGraphParamRecordingValid("cameraInput");
				bActive = true;
			} else {
				opennessFactor = 0;	// normalize undefined
			}
			
			if (bActive) {
				var strength = 1,
					transform = {},
					movement = args.getParam("movement"),
					factor = (opennessFactor*flappiness + ampFactor*audioFlappiness),
					bWorkaround = false;

				if (self.lastMovement !== undefined) {
					if (self.lastMovement !== movement) {
						// just changed by user, work around lingering task issue (DVACH-1321)
						bWorkaround = true;
					}
				}

				if (movement === kMovementPosition) {
					var maxMovement = 100;		// TODO: measure instead
					
					transform.y = factor * maxMovement;
					
					if (bWorkaround) {
						transform.angle = 0;
					}
				} else {
					var maxAngle = 45;			// degrees
					
					transform.angle = Z.mathUtils.rad(factor * maxAngle);
					
					if (movement === kMovementRotationCCW) {
						transform.angle *= -1;
					}
					if (bWorkaround) {
						transform.y = 0;
					}
				}
				
				self.targets.forEach(function (h) {
					tasks.handle.attachTask(h, new tasks.MoveTo(transform), strength);
				});
				
				self.lastMovement = movement;
			}
		}

	}; // end of object being returned
});
